# Supported kernel versions

This package is supported on the following Linux distribution kernels:

- Red Hat Enterprise Linux 8.1 to 8.9, 9.0 to 9.6 and derivatives (CentOS, Rocky, Alma)
- SUSE Enterprise Linux 15
- Ubuntu 24 LTS (kernel 6.8), 22.10, 23.10
- Ubuntu 22 LTS (kernels 5.15, 6.8), 21.10
- Ubuntu 20 LTS (kernels 5.4, 5.15), 20.10
- Ubuntu 18 LTS (kernels 4.15, 5.4), 18.10, 19.10
- Regular (non-LTS) Ubuntu releases: 23.10, 22.10, 21.10, 20.10, 19.10, 18.10

Generic upstream kernel support ranges are the following:

- Linux v4.15 to v6.8.

Attempting to build for an unsupported kernel may produce compilation
errors.

NOTE: Some older distribution kernels (such as RH 8.1) may require a recent
Mellanox OFED being installed, as it provides a more recent IB layer along with
newer kernel APIs.


## Legacy VAST NFS 3.x fallback

The source package for VAST NFS 4.x includes the older VAST NFS 3.x branch
code targeting older kernels that belong to:

- Red Hat Enterprise Linux 7.x and derivatives (CentOS 7.x)
- SUSE Enterprise Linux 12

Building the 4.x source package will result in a package marked as 3.x due to
the less supported functionality. It currently has less functionality than 4.x
(e.g. for NFSv4.1 mounts, no `remoteports`-based multipath).
