# Installation problems

## `dnf` errors about conflicting prerequisites

If you have a custom-built kernel you might encounter an error like this:

```
sudo dnf install dist/vastnfs-4.0.23-kernel_5.15.147.el9.x86_64.rpm
...
Error:
 Problem: conflicting requests
  - nothing provides kernel(PDE_DATA) = 0x0e0f5bd2 needed by vastnfs-4.0.23-kernel_5.15.147.el9.x86_64 from @commandline
  - nothing provides kernel(__alloc_pages) = 0xc7233469 needed by vastnfs-4.0.23-kernel_5.15.147.el9.x86_64 from @commandline
  - nothing provides kernel(__bitmap_weight) = 0x63c4d61f needed by vastnfs-4.0.23-kernel_5.15.147.el9.x86_64 from @commandline
  - nothing provides kernel(__cpu_online_mask) = 0x564405cb needed by vastnfs-4.0.23-kernel_5.15.147.el9.x86_64 from @commandline
...
```

The problem is that the `kernel-core` package for your kernel is not reporting
features that the vastnfs package requires. This could either be due to:

* The target kernel is installed from a custom kernel RPM, but that RPM was
  not properly built to include kabichk 'provides' specifications
  (standard RHEL-based kernels always have kabichk).
* The target kernel wasn't installed with `rpm`/`dnf`/`yum` but rather
  installed using some custom setup.

Confirm that your kernel is installed as a package by checking with `rpm`:

```
$ rpm -qa | grep kernel-core
```

You can see what `kernel()` features that `kernel-core` package says it
provides with:

```
$ rpm -q --provides kernel-core-$(uname -r) | grep kernel
```

If the kernel was installed with a package but the package doesn't say it
provides the symbols vastnfs is looking and you suspect it's a packaging
issue with your custom kernel RPM you can force the install with `--nodeps`
to bypass the dependency check.

```
$ sudo rpm -i --nodeps ./dist/vastnfs-vast*.x86_64.rpm
```

A reboot is required for the new drivers to load.

If the vastnfs driver works in this configuration consider updating your custom
RPM kernel builds to specify the kernel features it provides to avoid this in
the future.


## `sunrpc: Unknown symbol mlx_backport_dependency_symbol (err -2)`

This means VAST NFS tried to load but the MOFED kernel layer is not loaded
and cannot load.

The reason is that by default a VAST NFS build depends directly on the MOFED
kernel modules in case the MOFED installation exists.

The usual scenario for this is following a kernel upgrade. After a kernel
upgrade, if the MOFED kernel modules are not prepared for the new kernel, they
are not loading, and system administrators sometimes don't notice it because
the inbox Infiniband layers are loaded instead and cover for that. However,
VAST NFS directly depends on the Infiniband layer it was compiled against.

The most trivial way is to reinstall MOFED (or at minimum, its kernel module
subpackage), followed by VAST NFS rebuild and install.

Another option, suppose that MOFED installation is no longer desired,
is to run `./build.sh bin --no-ofed` to create a VAST NFS build that does
not depend on it, and reinstall it instead.


## Compilation errors when used with DOCA OFED following kernel upgrade within the same RHEL minor

Kernel updates within the same RHEL minor (e.g., '4.18.0-553' to e.g., '4.18.0-553.69.1'), _sometimes_ break the ability to build or load VAST NFS.

The workaround is to rebuild and reinstall the OFED kernel modules, and then rebuild VAST NFS kernel modules ontop.

```
dnf install -y doca-extra kernel-devel-$(uname -r)
rm -rf /tmp/DOCA.*
/opt/mellanox/doca/tools/doca-kernel-support
cd /tmp/DOCA.*
rpm -Uvh doca-kernel-repo*.rpm
dnf makecache
dnf install -y doca-ofed-userspace
dnf install -y --disablerepo=doca doca-kernel-\*

# Reinstall mlnx-ofa_kernel-devel to support VAST NFS rebuild
dnf download mlnx-ofa_kernel-devel
rpm2cpio mlnx-ofa_kernel-devel-*.rpm  | (cd / && cpio -imdv)
ln -sf /usr/src/ofa_kernel/x86_64/$(uname -r) /etc/alternatives/ofa_kernel_headers
```

(Last three commands are workaround to bring the new `mlnx-ofa_kernel-devel`, because a trivial `dnf install -y mlnx-ofa_kernel-devel` does not do the right thing. NVIDIA may fix this issue in the future)

### Older procedure for Mellanox OFED

An alternative to the procedure above for MLNX OFED, without going through DOCA OFED RPMs or procedure:

```
# Making some dependencies are installed
dnf install -y kernel-devel-$(uname -r) patch

# Copying of OFA kernel source
cd /usr/src
(if [[ -e ofa_kernel/x86_64/$(uname -r) ]] ; then echo ERROR: ofa_kernel/x86_64/$(uname -r) already exists; sleep 5; exit 1 ; fi)
cp -a ofa_kernel-*/source/ ofa_kernel/x86_64/$(uname -r)

# Configuring and rebuilding mlnx-ofa_kernel based on the original build's configure.mk.kernel
cd ofa_kernel/x86_64/$(uname -r)
./configure --with-linux-obj=/usr/src/kernels/$(uname -r) --with-njobs=32 $(for i in $(cat /usr/src/ofa_kernel/x86_64/$(readlink -f -- $(modinfo mlx_compat | grep filename: | awk '{print $2}')| awk -F/ '{print $5}')/configure.mk.kernel | grep ^CONFIG_ | uniq); do ./configure --help | grep -E " $i " ; done | awk -F" " '{print $1}') -j32
make -j32
make install -j32
# Pointing to it
ln -sf /usr/src/ofa_kernel/x86_64/$(uname -r) /etc/alternatives/ofa_kernel_headers

# Making sure initramfs contains the regenerated mlnx-ofa_kenrel
dracut -f
```
