# ARP configuration

For usage of `localports=` multipath (see [mount
parameters](../../usage/mount-params.md), there are several `sysctl` configuration
that need to apply to make sure traffic goes in an out of the correct
interface.


## `rp_filter`

When using `localports=`, make sure that the `rp_filter` sysctl option is
disabled on the corresponding network interfaces, **for each interface**:

```
echo 'net.ipv4.conf.<iface>.rp_filter = 0' >> /etc/sysctl.d/nfs-multipath.conf
```

It may be easier to disable for all of them depending of circumstances:

```
echo 'net.ipv4.conf.all.rp_filter = 0' >> /etc/sysctl.d/nfs-multipath.conf
```

To load the new configuration, run `/usr/bin/sysctl --system`.



## `arp_announce` and `arp_ignore`


Similar to the above, set, **for each interface** set:

```
echo 'net.ipv4.conf.<iface>.arp_announce = 1' >> /etc/sysctl.d/nfs-multipath.conf
echo 'net.ipv4.conf.<iface>.arp_ignore = 2' >> /etc/sysctl.d/nfs-multipath.conf
```

To load the new configuration, run `/usr/bin/sysctl --system`.


## Persisting sysctl changes with NetworkManager


For setups with NetworkManager, create a script to automatically apply sysctl
when interfaces are up:

```
echo -e '#!/bin/bash\n\n/usr/bin/sysctl --system\n' > /etc/NetworkManager/dispatcher.d/00-sysctl
chmod +x /etc/NetworkManager/dispatcher.d/00-sysctl
```
