# 4.0.39

(released Feb 12, 2026)

* Fix an inter-op bug specifically with Linux LTS 6.1.x tree that caused an incorrect file position iterator handling

# 4.0.38

(released Jan 7, 2026)

* Introduce a new mount option `pconnect` (see documentation).
* `localports` enables `localports_failover` and `noidlexprt` by default.
* `localports` usage with one outbound port offline during mount, now tries to
  find a working local port out of the provided set for the mount to succeed.
* Build fix for SUSE kernel `6.4.0-150600.21-default`.
* Documentation updates.

# 4.0.37

(released Nov 18, 2025)

* Backport NFSv4.1 `remoteports=` multipath fixes from v4.5.x branch.
* Backport upstream fix for dentry verifier of links (commit `v5.16-rc1~56^2~83`).
* Documentation updates

# 4.0.36

(released Oct 4, 2025)

* For kernel 5.15-5.17, fix readahead performance under mmap with multiple processes
* Documentation updates (CoreOS support, DOCA OFED workarounds)

# 4.0.35

(released Aug 25, 2025)

* Backported fixes for retry issues with Kerberos
* Prevent duplicate `noextend` mount option showing up /proc/mounts
* Fix unresponsive rpc-gssd in rare cases (for debug)
* Fix an issue with NFSv4.x client-based multipath on remounts
* Interleave localports for NFSv4.1 multipath usage
* Fix symbols exports for GDS usage (for newer DOCA/MLNX OFED versions)
* build: Remove benign error prints for missing $PATH entries
* build: Fix incorrect print about git status
* Documentation updates (ARP, vastnfs-ctl)

# 4.0.34

(released Jun 13, 2025)

* Fix a regression with `spread_reads` and `spread_writes` performance.
* Fix a issues related to `mdconnect` implementation.
* Fix a crash with `buffered_internal_writeback` related to `writev` calls.

# 4.0.33

(released Apr 24, 2025)

* Introduce `mdconnect` mount option to isolate metadata RPC connections for NFSv3 workloads
* For RHEL9.5 and newer kernels, update compatibility layers
* Add Debian installation dependency on `nfs-common` and run `weak-modules` on RHEL8/9 to ensure kernel modules are properly integrated
* Support separate transport channels for NFS mounts via new `nosharetransport` (NFSv3) and `sharetransport=N` (NFSv4) mount options
* Enhance Makefile: centralize NFS config definitions; fix GCC version parsing; improve RPM-based distribution error messaging
* Improve scripts: add missing trace events and revert an unintended change
* Fix sunrpc crash with backchannels when `rpc_task_state_transition` is enabled
* Correct tracepoint error in `trace_nfs3proc_access`


# 4.0.32

(released Dec 19, 2024)

* Fix a backporting bug for older kernels (5.2 and below) that caused FD leak in `rpc-gssd`, relevant only for setups where Kerberos is used on those kernels.


# 4.0.31

(released Nov 24, 2024)

* Fix a build issue where source tarball is unpack in a path that has symlink components
* Fix module signing on Ubuntu
* Backport 'sunrpc: fix NFSACL RPC retry on soft mount' from upstream
* For KRB5 setups using PID-based credentials cache, add fixes for NFSv4 IO recovery modes
* Don't ignore `localports=` mount option with NFSv4.x
* Don't ignore `noidlexprt` mount param with NFSv4.x
* Extend `vastnfs-ctl` with status commands for transports and clients
* For NFS4.x show remoteports in `mountstats`
* Documentation fixes

# 4.0.30

(released Sep 10, 2024)

* Fix a rare case of stuck IOs in NFS v4.1 `remoteports=` multipath
* Fix documentation regarding `remoteports=dns`
* Fix mount failure when `remoteports=dns` is passed and `nconnect` is not
* Remove unwanted caching of DNS results when `remoteports=dns` is used
* Fix an issue with `buffered_internal_writeback` and unaligned user buffers
* Show the extra mount options in the output of mount for existing mounts (except: NFSv4.1 `remoteports` mode)

# 4.0.29

(released Jul 24, 2024)

* Support up to Linux 6.8
* Fix stability issues regard `remoteports=dns` feature
* Fix stability issues regard passing network device names in `localports=`
* Backport fix for idmapper upcall (upstream commit [`51fd2eb52c0ca827`](https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?h=51fd2eb52c0ca827))
* Further fixes for recovery states when using RDMA bonding devices

# 4.0.28

(released Jul 01, 2024)

* Introduced a new `buffered_internal_writeback` module parameter, which enhances write performance on older kernels. When enabled, it applies to synchronous and large page-aligned writes. These writes are buffered but behave similarly to `O_DIRECT` writes by bypassing the overhead of the Linux writeback.
* Added support for Oracle Linux 8.9.

# 4.0.27

(released May 16, 2024)

* Bugfix for Linux kernel 4.19.x LTS tree changes
* Fix for `remoteports=` ranges on IPv6 addresess
* Support `remoteports=dns` mode
* Fix for recovery states when using RDMA bonding devices
* Automatic readlink retry via lookup. This allows clients to replace symlinks in directories using `rename` without causing _other_ clients to fail when using them for path traversal. This improvement is pending upstream NFS client contribution.
* When debugging with all trace-events enabled, fix for stability
* Documentation changes

# 4.0.26

(released Apr 04, 2024)

* Support for Linux kernels up to Linux 6.6
* Import stability patches from Linux LTS 5.15.x tree up to 5.15.147
* Add an `optlockflush` mount option (see documentation)
* Add a `noextend` mount option (see documentation)
* Debian packaging: add missing depmod call on install
* Debian packaging: fix build error on compressed kernel modules
* Fix backporting issue regarding `srcaddr` access in sysfs
* build.sh: fix Oracle Linux detection
* Various documentation changes

# 4.0.25

(released Mar 26, 2024)

* Add `relmtime` mount option (see documentation).

# 4.0.24

(released Feb 26, 2024)

* Bugfix for rare cases of lost writeback in backported code from Linux 5.18 to 6.7.

# 4.0.23

(released Jan 19, 2024)

* Support RHEL 9.3.
* Support up to upstream kernels Linux 6.2.
* Fix the `localports_failover` implementation which was broken due to a trivial bug.
* Allow interop with builds of Lustre (only ones that have Kerberos disabled).

# 4.0.22

(released Oct 12, 2023)

* Support passing network device names in `localports=`.

# 4.0.21

(released Oct 12, 2023)

* Fix crash when using xattrs under NFS protocol version 4.2.

# 4.0.20

(released Sep 12, 2023)

* Improve kernel header detection on Debian
* Linux 5.15.x LTS sync to v5.15.126.
* nfsd: fix support for xattrs on various kernels
* 3.9.x fallback sync: v3.9.30.

# 4.0.19

(released Aug 15, 2023)

* Fix for upcoming RHEL 8.9 kernels.
* NFSv4.1 support for NFS4_RESULT_PRESERVER_UNLINKED

# 4.0.18

(released Jun 17, 2023)

* Fix for Ubuntu kernels 5.19.x.

# 4.0.17

(released May 29, 2023)

* Support for Linux kernels up to 5.19, including.
* Support for RHEL 9.2.
* Tracing improvements.

# 4.0.16

(released Apr 03, 2023)

* Fix nfsd (the NFS server service) for various platforms, instead of loading a stub. Platforms include later RHEL 8.x and above ; Linux 5.4.0 kernels and above.
* Add the `spread_reads` and `spread_writes` mount parameters. These allow `remoteports=`-based NFSv3 multipath spread of IOs on single files, in contrast to the default where file handles pin to remote IP address to obtain cache locality in remote servers. NFSv4.1 `remoteports=` multipath is unchanged.

# 4.0.15

(released Mar 09, 2023)

* Build fixes for OFED-5.9.
* Fix stuck IOs in NFS v4.1 remoteports= multipath.
* Packaging sync of legacy 3.x branch to 3.9.27.

# 4.0.14

(released Feb 07, 2023)

* Packaging sync of legacy 3.x branch to 3.9.26.

# 4.0.13

(released Feb 05, 2023)

* Build fix for Scientific Linux detection.
* Support RHEL 9.1.

# 4.0.12

(released Jan 19, 2023)

* Fix read_ahead_kb default for kernel targets to be between 60 KB and 128 KB.

# 4.0.11

(released Jan 08, 2023)

* Package meta-data fix.

# 4.0.10

(released Dec 07, 2022)

* An additional compatibility fix was required to prevent a crash on sysctl
  access. The crash only happened with `rpcrdma` loaded under kernels older than
  Linux v5.7 which don't contain a backport of upstream commit 32927393dc1.

# 4.0.9

(released Nov 30, 2022)

* A fix for a compat check under SLES15 that caused a specific known crash
  during sysctl access.

# 4.0.8

(released Nov 02, 2022)

* Re-enable multipath roundrobin of meta-data IOs for NFSv3.

# 4.0.7

(released Oct 30, 2022)

* A small fix for SID-based GSS auth tracking.

# 4.0.6

(released Oct 23, 2022)

* Fixes to `vastnfs-ctl trace` command.

# 4.0.5

(released Oct 20, 2022)

* Sync to upstream v5.15.73 TLS kernel.
* Extending trace points for most of the stack.
* Add `vastnfs-ctl trace` command.

# 4.0.4

(released Sep 30, 2022)

* Build script fixes

# 4.0.3

(released Sep 30, 2022)

* Build script fixes

# 4.0.2

(released Sep 14, 2022)

* Import patches from 3.9.21.

# 4.0.1

(released Aug 25, 2022)

* Fix `build.sh` execute mode bit.
* Remove legacy root directory docs. All docs are now under `docs/`.

# 4.0

* Initial version, including support for SID-based GSS auth tracking.

# 3.9.x

For older changes, see the [change log for the older 3.9.x branch](https://vastnfs.vastdata.com/docs/3.9.x/ChangeLog.html).
