%{!?_name: %define _name vastnfs}
%{!?_version: %define _version 4.0}
%{!?_release: %define _release %{nil}}

# KMP is disabled by default
%{!?KMP: %global KMP 0}

# take kernel version or default to uname -r
%{!?KVERSION: %global KVERSION %(uname -r)}
%global krelver %(echo -n %{KVERSION} | sed -e 's/-/_/g')

# define release version
%{!?src_release: %global src_release %{_release}_%{krelver}}
%if "%{KMP}" != "1"
%global _release1 %{src_release}
%else
%global _release1 %{_release}
%endif

Summary: Akmod package for %{_name} driver
Name: akmod-%{_name}
Version: %{_version}
Release: %{_release1}%{?_dist}
License: GPLv2
Group: System Environment/Base
Requires: akmods, kernel-devel
BuildRequires: akmods, kernel-devel
Provides: %{_name}-akmod
Vendor: VAST Data
%description
This package contains akmod sources for %{_name} to build against kernel versions dynamically.

%install
rm -rf %{buildroot}/usr/src/akmods
mkdir -p %{buildroot}/usr/src/akmods
cp %{_rpmdir}/%{_name}-%{_version}-%{_release1}.src.rpm %{buildroot}/usr/src/akmods
pushd %{buildroot}/usr/src/akmods
ln -s %{_name}-%{_version}-%{_release1}.src.rpm %{_name}-kmod.latest
popd

%files
/usr/src/akmods/%{_name}-%{_version}-%{_release1}.src.rpm
/usr/src/akmods/%{_name}-kmod.latest

%post
[ -x /usr/sbin/akmods-ostree-post ] && /usr/sbin/akmods-ostree-post %{_name} /usr/src/akmods/%{_name}-%{_version}-%{_release1}.src.rpm

%posttrans
nohup /usr/sbin/akmods --from-akmod-posttrans --akmod %{_name} &> /dev/null &

