/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2014 Anna Schumaker.
 *
 * NFSv3-specific filesystem definitions and declarations
 */
#ifndef __LINUX_FS_NFS_NFS3_FS_H
#define __LINUX_FS_NFS_NFS3_FS_H

/*
 * nfs3acl.c
 */
#ifdef CONFIG_NFS_V3_ACL
#ifdef COMPAT_DETECT_GET_ACL_OLD_SIGNATURE_5_15
extern struct posix_acl *nfs3_get_acl(struct inode *inode, int type);
#else
extern struct posix_acl *nfs3_get_acl(struct inode *inode, int type, bool rcu);
#endif
#ifdef COMPAT_DETECT_SET_POSIX_ACL_USES_DENTRY_6_2
extern int nfs3_set_acl(COMPAT_STRUCT_MNT_IDMAP *idmap, struct dentry *dentry,
			struct posix_acl *acl, int type);
#else
extern int nfs3_set_acl(COMPAT_STRUCT_MNT_IDMAP *idmap, struct inode *inode,
			struct posix_acl *acl, int type);
#endif
extern int nfs3_proc_setacls(struct inode *inode, struct posix_acl *acl,
		struct posix_acl *dfacl);
extern ssize_t nfs3_listxattr(struct dentry *, char *, size_t);
#ifdef COMPAT_DETECT_POSIX_ACL_ACCESS_XATTR_HANDLER_6_4
extern const struct xattr_handler *nfs3_xattr_handlers[];
#endif
#else /* !CONFIG_NFS_V3_ACL */
static inline int nfs3_proc_setacls(struct inode *inode, struct posix_acl *acl,
		struct posix_acl *dfacl)
{
	return 0;
}
#define nfs3_listxattr NULL
#endif /* CONFIG_NFS_V3_ACL */

/* nfs3client.c */
struct nfs_server *nfs3_create_server(struct fs_context *);
struct nfs_server *nfs3_clone_server(struct nfs_server *, struct nfs_fh *,
				     struct nfs_fattr *, rpc_authflavor_t);

/* nfs3super.c */
extern struct nfs_subversion nfs_v3;

#endif /* __LINUX_FS_NFS_NFS3_FS_H */
