/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2021 Oracle and/or its affiliates.
 *
 * Common types and format specifiers for sunrpc.
 */

#if !defined(_TRACE_SUNRPC_BASE_H)
#define _TRACE_SUNRPC_BASE_H

#include <linux/version.h>
#include <linux/tracepoint.h>

#define SUNRPC_TRACE_PID_SPECIFIER	"%llx"
#define SUNRPC_TRACE_CLID_SPECIFIER	"%u"
#define SUNRPC_TRACE_TASK_SPECIFIER \
	"task:" SUNRPC_TRACE_PID_SPECIFIER "@" SUNRPC_TRACE_CLID_SPECIFIER

#if LINUX_VERSION_CODE < KERNEL_VERSION(6, 10, 0)
#define __assign_str_wrap(name, data)		__assign_str(name, data)
#else
#define __assign_str_wrap(name, data)		__assign_str(name)
#endif

#endif /* _TRACE_SUNRPC_BASE_H */
