#ifndef __COMPAT_LINUX_FS_NOTIFY_BACKEND_H__
#define __COMPAT_LINUX_FS_NOTIFY_BACKEND_H__

#include_next <linux/fsnotify_backend.h>

#ifdef COMPAT_DETECT_FSNOTIFY_ALLOC_GROUP_5_19

static inline struct fsnotify_group *
compat_fsnotify_alloc_group(const struct fsnotify_ops *ops)
{
	return fsnotify_alloc_group(ops,
#ifdef FSNOTIFY_GROUP_NOFS
				FSNOTIFY_GROUP_NOFS);
#else
				0);
#endif
}

#else /* !COMPAT_DETECT_FSNOTIFY_ALLOC_GROUP_5_19 */

#define compat_fsnotify_alloc_group fsnotify_alloc_group

static inline void fsnotify_group_lock(struct fsnotify_group *group)
{
	mutex_lock(&group->mark_mutex);
}

static inline void fsnotify_group_unlock(struct fsnotify_group *group)
{
	mutex_unlock(&group->mark_mutex);
}

#endif /* COMPAT_DETECT_FSNOTIFY_ALLOC_GROUP_5_19 */
#endif /* __COMPAT_LINUX_FS_NOTIFY_BACKEND_H__ */
