#ifndef __COMPAT_LINUX_POSIX_ACL_H__
#define __COMPAT_LINUX_POSIX_ACL_H__

#include_next <linux/posix_acl.h>

#ifndef COMPAT_DETECT_GET_INODE_ACL_6_2
static inline struct posix_acl *get_inode_acl(struct inode *inode, int type)
{
	return get_acl(inode, type);
}
#endif

#ifndef COMPAT_DETECT_SET_POSIX_ACL_USES_DENTRY_6_2
static inline int compat_set_posix_acl(COMPAT_STRUCT_MNT_IDMAP *idmap,
			struct dentry *dentry, int type, struct posix_acl *acl)
{
	return set_posix_acl(idmap, d_inode(dentry), type, acl);
}
#define set_posix_acl compat_set_posix_acl
#endif

#endif /* __COMPAT_LINUX_POSIX_ACL_H__ */
