# Supported kernel versions

This package is supported on the following Linux distribution kernels:

- Red Hat Enterprise Linux 9.3 to 9.6 and derivatives (CentOS, Rocky, Alma)
- Red Hat Enterprise Linux 10.0 and derivatives (CentOS, Rocky, Alma)
- SUSE Enterprise Linux 15 SP7 and above
- Ubuntu 24 LTS with 6.8 HWE kernel to 6.17 HWR kernel (including)
- Ubuntu 22 LTS with 6.8 HWE kernel to 6.17 HWR kernel (including)
- Ubuntu 20 LTS with 6.8 HWE kernel to 6.17 HWR kernel (including)

Generic upstream kernel support ranges are the following:

- Linux v6.5 to v6.17 (including)

**NOTE: For older kernels and distributions, see legacy support in this page below.**

When building under a NVIDIA/Mellanox OFED environment, the IB layer of OFED
is targeted for NFS RDMA support.


## Legacy VAST NFS version 4.0.x fallback

The source package for VAST NFS 4.5.x includes the older VAST NFS 4.0.x branch
code targeting older kernels that belong to:

- Red Hat Enterprise Linux 8.1 to 8.9, 9.3 and derivatives (CentOS, Rocky, Alma)
- SUSE Enterprise Linux 15
- Ubuntu 22 LTS
- Ubuntu 20 LTS
- Ubuntu 18 LTS

Generic upstream kernel support ranges are the following:

- Linux v4.15 to v6.6.

NOTE: Some older distribution kernels (such as RH 8.1) may require a recent
Mellanox OFED being installed, as it provides a more recent IB layer along with
newer kernel APIs.


## Legacy VAST NFS 3.x fallback

The source package for VAST NFS 4.5.x includes the older VAST NFS 3.x branch
code targeting older kernels that belong to:

- Red Hat Enterprise Linux 7.x and derivatives (CentOS 7.x)
- SUSE Enterprise Linux 12

Building the 4.x source package will result in a package marked as 3.x due to
the less supported functionality. It currently has less functionality than 4.x
(e.g. for NFSv4.1 mounts, no `remoteports`-based multipath).
