## Installing under Ubuntu/Debian

(see supported versions [here](../build/kernels.md))

For Ubuntu/Debian, either a DKMS-based package or kernel module binary package
was generated by the build command (see [build section](../build/package.md))

- For binary packages:

```
sudo dpkg -i ./dist/vastnfs-modules_*-generic_amd64.deb
sudo update-initramfs -u -k `uname -r`
```

Alternatively,


- For DKMS packages:

```
sudo dpkg -i ./dist/vastnfs-dkms_*.deb
```

This should result in the generation of kernel module binaries by the DKMS subsystem.


Verify that the package is indeed installed (versions should match):

```
dpkg -l | grep vastnfs-modules
```

To further validate installation, verify that `rpcrdma` in the right path
exists and get loaded from it.  All the added kernel modules go under
`updates/bundle`:

```
dpkg -S /lib/modules/`uname -r`/updates/bundle/net/sunrpc/xprtrdma/rpcrdma.ko
```

## Verification

Reboot, to ensure that this version is loaded correctly.

Once rebooted, and to verify fully once it is loaded, for each kernel module,
loaded version should match installed version. For example:

```
$ cat /sys/module/sunrpc/srcversion
4CC8389C7889F82F5A59269

$ modinfo sunrpc | grep srcversion
srcversion:     4CC8389C7889F82F5A59269
```

(This is only an example - srcversion is different for each build and kernel module).
