# vastnfs-ctl

This helper script is installed with the package, and can assist in various
situations.

The usage of this script is optional in most cases.


## Status

Observe the status of the loaded NFS services and kernel modules

`vastnfs-ctl status`

Example output:

```
version: v4.0-pre4-11-ge520dd8eb9cb
kernel modules: sunrpc rpcrdma compat_nfs_ssc lockd nfs_acl auth_rpcgss nfsd rpcsec_gss_krb5 nfs nfsv3 nfsv4
services: rpcbind.socket rpcbind
rpc_pipefs: /var/lib/nfs/rpc_pipefs
```

## Reload

The following command will try to reload the NFS stack. It will first try to
unmount all NFS file systems, and then reload all the necessary kernel modules.

`vastnfs-ctl reload`

Example output:

```
vastnfs-ctl: stopping service rpcbind.socket
vastnfs-ctl: umounting fs /var/lib/nfs/rpc_pipefs
vastnfs-ctl: unloading kmod nfsv4
vastnfs-ctl: unloading kmod nfsv3
vastnfs-ctl: unloading kmod nfs
vastnfs-ctl: unloading kmod rpcsec_gss_krb5
vastnfs-ctl: unloading kmod nfsd
vastnfs-ctl: unloading kmod auth_rpcgss
vastnfs-ctl: unloading kmod nfs_acl
vastnfs-ctl: unloading kmod lockd
vastnfs-ctl: unloading kmod compat_nfs_ssc
vastnfs-ctl: unloading kmod rpcrdma
vastnfs-ctl: unloading kmod sunrpc
vastnfs-ctl: loading kmod sunrpc
vastnfs-ctl: loading kmod rpcsec_gss_krb5
vastnfs-ctl: loading kmod rpcrdma
vastnfs-ctl: loading kmod nfsv4
vastnfs-ctl: loading kmod nfsv3
vastnfs-ctl: loading kmod nfsd
vastnfs-ctl: loading kmod nfs_acl
vastnfs-ctl: loading kmod nfs
vastnfs-ctl: loading kmod lockd
vastnfs-ctl: loading kmod compat_nfs_ssc
vastnfs-ctl: loading kmod auth_rpcgss
vastnfs-ctl: mounting fs /var/lib/nfs/rpc_pipefs
vastnfs-ctl: starting service rpcbind.socket
```

## Tracing

The `vastnfs-ctl` utility comes with a helper command for tracing the NFS
stack. Please see a [short tutorial on using vastnfs-ctl trace](../monitoring/tracing.md).


## Show NFS Clients

Use `vastnfs-ctl nfs-clients path` to show the status of NFS client used by specific `path`.
Use `vastnfs-ctl nfs-clients` to show status of all active NFS clients.

Example output:
```
NFS client 3000
	state: 0
	hostname: server.nfs-testing.com
	rpc_clnt: 3
```

`hostname`: The used NFS server
`rpc_clnt`: The RPC client's ID used by the NFS client


## Show RPC Clients Used by the NFS Protocol

Use `vastnfs-ctl rpc-clients <path>` to display the status of RPC clients for a specific `path`.
Use `vastnfs-ctl rpc-clients` to display the status of all active RPC clients.

Note: This command shows RPC clients used by the NFS protocol only. Clients used by other protocols aren't included.

Example output:
```
rpc_client: 3 switch-2002
	sunrpc-id:	3
	RPC iostats version: 1.1  p/v: 100003/3 (nfs)
	xprt:	tcp 1012 1 2 0 0 6474 6473 0 77192 3579 128 26235 66718
		192.168.23.11, state: CONNECTED BOUND
		remote_port_idx: 0
		role: REG
		pci device:
		hardware gpus:
	remoteports_offset: 0 0
	spread reads: 0 writes: 0
	mdconnect: 0
	per-op statistics
	        NULL: 1 1 0 44 24 0 0 0 0
	     GETATTR: 0 0 0 0 0 0 0 0 0
	     SETATTR: 0 0 0 0 0 0 0 0 0
	      LOOKUP: 0 0 0 0 0 0 0 0 0
	      ACCESS: 0 0 0 0 0 0 0 0 0
	    READLINK: 0 0 0 0 0 0 0 0 0
	        READ: 0 0 0 0 0 0 0 0 0
	       WRITE: 0 0 0 0 0 0 0 0 0
	      CREATE: 0 0 0 0 0 0 0 0 0
	       MKDIR: 0 0 0 0 0 0 0 0 0
	     SYMLINK: 0 0 0 0 0 0 0 0 0
	       MKNOD: 0 0 0 0 0 0 0 0 0
	      REMOVE: 0 0 0 0 0 0 0 0 0
	       RMDIR: 0 0 0 0 0 0 0 0 0
	      RENAME: 0 0 0 0 0 0 0 0 0
	        LINK: 0 0 0 0 0 0 0 0 0
	     READDIR: 0 0 0 0 0 0 0 0 0
	 READDIRPLUS: 0 0 0 0 0 0 0 0 0
	      FSSTAT: 0 0 0 0 0 0 0 0 0
	      FSINFO: 0 0 0 0 0 0 0 0 0
	    PATHCONF: 0 0 0 0 0 0 0 0 0
	      COMMIT: 0 0 0 0 0 0 0 0 0
```

`rpc_client`: The unique ID of the RPC client and the associated transport switch.
`xprt`: The brief status of transport/transports.


## Show RPC Transport Switches

Use `vastnfs-ctl rpc-switches <path>` to show the status of RPC transport switches for a specific `path`.
Use `vastnfs-ctl rpc-switches` to show the status of all active RPC transport switches.

Example output:
```
RPC switch-2002
        num_xprts=1
        num_active=1
        num_unique_destaddr=1
        queue_len=0
        xprt-2-tcp: CONNECTED   BOUND
```

`queue_len`: The number of currently allocated RPC tasks for this transport switch.
`xprt-2-tcp`: The transport (or list of transports) in use, along with their current status (e.g., `CONNECTED`, `BOUND`).


## Show RPC Transports

Use `vastnfs-ctl rpc-transports <path>` to show RPC transports associated with a specific `path`.
Use `vastnfs-ctl rpc-transports` to show all active RPC transports used by the NFS protocol.

Example output:
```
xprt-2-tcp     BOUND
        dstaddr=192.168.23.11
        remote_port_idx=0
        reconnection_attempts=0
        transport=tcp 986 1 2 0 0 7 7 0 7 0 2 0 0
```

First line displays the name of the transport `xprt-2-tcp` and its current state (`BOUND` or `CONNECTED`, etc.).
Last line is transport protocol-dependent and shows the protocol name and internal state.

## Show Cached NFS Inode State

Use `vastnfs-ctl dump-meta-data <path>` to show the inode state using the file's absolute `path`.
Use `vastnfs-ctl dump-meta-data :inode@mount_point` to show the inode state by inode number and mount point.
Use `vastnfs-ctl dump-meta-data :inode@fsid` to show the inode state by inode number and `fsid`, where `fsid` is the value from the third column of `/proc/self/mountinfo`.

Example output:
```
junk.fsxlog fh 0x010001010100000066f43ebcefa3000000000000
idx 0 mode 0100644 owner 0:0 flags 0x82:0xc nlink 1
size 285 state 0x100 version 1879990373217750775 count 0
atime 1750877260079976788ns mtime 1750877474684478199ns ctime 1750877474684478199ns
nfsi flags 0x4 cache validity 0x0 gencount 4942822 attrtimeo 12000
timestamp 4297125548 unlock_mtime 0ns jiffies 217558
access_cache 1 entryes, cached 0 pages flags 0x0
```

First line displays the file name and its NFS file handle.
