#include <linux/module.h>
#include <linux/fs.h>
#include <linux/posix_acl.h>

#include "../../compat.h"

/* LAYER: 2 */

#ifndef COMPAT_STRUCT_MNT_IDMAP
#ifdef COMPAT_DETECT_GENERIC_PERMISSION_MNT_IDMAP_6_3
#define COMPAT_STRUCT_MNT_IDMAP	struct mnt_idmap
#else
#define COMPAT_STRUCT_MNT_IDMAP	struct user_namespace
#endif
#endif /* COMPAT_STRUCT_MNT_IDMAP */

/*
 * v6.2-rc1~158^2~34 ""fs: pass dentry to set acl method
 */
static int test_dummy(COMPAT_STRUCT_MNT_IDMAP *idmap, struct dentry *dentry,
				int type, struct posix_acl *acl)
{
	return set_posix_acl(idmap, dentry, type, acl);
}

EXPORT_SYMBOL(test_dummy);
MODULE_LICENSE("GPL");
