#include <linux/module.h>
#include <linux/fs.h>

#include "../../compat.h"

/* LAYER: 2 */

#ifndef COMPAT_STRUCT_MNT_IDMAP
#ifdef COMPAT_DETECT_GENERIC_PERMISSION_MNT_IDMAP_6_3
#define COMPAT_STRUCT_MNT_IDMAP        struct mnt_idmap
#else
#define COMPAT_STRUCT_MNT_IDMAP        struct user_namespace
#endif
#endif /* COMPAT_STRUCT_MNT_IDMAP */

/*
 * v6.2-rc1~157^2~4 "attr: add setattr_should_drop_sgid()"
 */
static int test_dummy(COMPAT_STRUCT_MNT_IDMAP *idmap, struct inode *inode)
{
	return setattr_should_drop_sgid(idmap, inode);
}

EXPORT_SYMBOL(test_dummy);
MODULE_LICENSE("GPL");
