#ifndef __COMPAT_LINUX_FILELOCK_H__
#define __COMPAT_LINUX_FILELOCK_H__

#include <linux/fs.h>

#ifdef COMPAT_DETECT_INCLUDE_LINUX_FILELOCK
#include_next <linux/filelock.h>
#endif

#ifdef COMPAT_DETECT_STRUCT_FILE_LOCK_CORE_6_9

#define for_each_file_lock(_fl, _head)  list_for_each_entry(_fl, _head, c.flc_list)
#define fl_list				c.flc_list

static inline bool compat_lock_is_unlock(const struct file_lock *fl)
{
	return lock_is_unlock((struct file_lock*)fl);
}

static inline bool compat_lock_is_read(const struct file_lock *fl)
{
	return lock_is_read((struct file_lock*)fl);
}

static inline bool compat_lock_is_write(const struct file_lock *fl)
{
	return lock_is_write((struct file_lock*)fl);
}

static inline fl_owner_t compat_file_lock_owner(const struct file_lock *fl)
{
	return fl->c.flc_owner;
}

static inline void compat_file_lock_set_owner(struct file_lock *fl, fl_owner_t owner)
{
	fl->c.flc_owner = owner;
}

static inline pid_t compat_file_lock_pid(const struct file_lock *fl)
{
	return fl->c.flc_pid;
}

static inline void compat_file_lock_set_pid(struct file_lock *fl, pid_t pid)
{
	fl->c.flc_pid = pid;
}

static inline unsigned char compat_file_lock_type(const struct file_lock *fl)
{
	return fl->c.flc_type;
}

static inline void compat_file_lock_set_type(struct file_lock *fl, unsigned char tp)
{
	fl->c.flc_type = tp;
}

static inline struct file *compat_file_lock_file(const struct file_lock *fl)
{
	return fl->c.flc_file;
}

static inline void compat_file_lock_set_file(struct file_lock *fl, struct file *file)
{
	fl->c.flc_file = file;
}

static inline unsigned int *compat_file_lock_flags(struct file_lock *fl)
{
	return &fl->c.flc_flags;
}

static inline fl_owner_t compat_file_lease_owner(const struct file_lease *fl)
{
	return fl->c.flc_owner;
}

static inline void compat_file_lease_set_owner(struct file_lease *fl, fl_owner_t owner)
{
	fl->c.flc_owner = owner;
}

static inline pid_t compat_file_lease_pid(const struct file_lease *fl)
{
	return fl->c.flc_pid;
}

static inline void compat_file_lease_set_pid(struct file_lease *fl, pid_t pid)
{
	fl->c.flc_pid = pid;
}

static inline unsigned char compat_file_lease_type(const struct file_lease *fl)
{
	return fl->c.flc_type;
}

static inline void compat_file_lease_set_type(struct file_lease *fl, unsigned char tp)
{
	fl->c.flc_type = tp;
}

static inline struct file *compat_file_lease_file(const struct file_lease *fl)
{
	return fl->c.flc_file;
}

static inline void compat_file_lease_set_file(struct file_lease *fl, struct file *file)
{
	fl->c.flc_file = file;
}

static inline unsigned int *compat_file_lease_flags(struct file_lease *fl)
{
	return &fl->c.flc_flags;
}

#else /* !COMPAT_DETECT_STRUCT_FILE_LOCK_CORE_6_9 */

#define for_each_file_lock(_fl, _head)  list_for_each_entry(_fl, _head, fl_list)

#define lease_manager_operations 	lock_manager_operations
#define file_lease 			file_lock

#define locks_alloc_lease 		locks_alloc_lock
#define locks_init_lease		locks_init_lock
#define locks_free_lease 		locks_free_lock

#define compat_file_lease_owner		compat_file_lock_owner
#define compat_file_lease_set_owner	compat_file_lock_set_owner
#define compat_file_lease_pid		compat_file_lock_pid
#define compat_file_lease_set_pid	compat_file_lock_set_pid
#define compat_file_lease_type		compat_file_lock_type
#define compat_file_lease_set_type	compat_file_lock_set_type
#define compat_file_lease_file		compat_file_lock_file
#define compat_file_lease_set_file	compat_file_lock_set_file
#define compat_file_lease_flags		compat_file_lock_flags

static inline bool compat_lock_is_unlock(const struct file_lock *fl)
{
	return fl->fl_type == F_UNLCK;
}

static inline bool compat_lock_is_read(const struct file_lock *fl)
{
	return fl->fl_type == F_RDLCK;
}

static inline bool compat_lock_is_write(const struct file_lock *fl)
{
	return fl->fl_type == F_WRLCK;
}

static inline fl_owner_t compat_file_lock_owner(const struct file_lock *fl)
{
	return fl->fl_owner;
}

static inline void compat_file_lock_set_owner(struct file_lock *fl, fl_owner_t owner)
{
	fl->fl_owner = owner;
}

static inline pid_t compat_file_lock_pid(const struct file_lock *fl)
{
	return fl->fl_pid;
}

static inline void compat_file_lock_set_pid(struct file_lock *fl, pid_t pid)
{
	fl->fl_pid = pid;
}

static inline unsigned char compat_file_lock_type(const struct file_lock *fl)
{
	return fl->fl_type;
}

static inline void compat_file_lock_set_type(struct file_lock *fl, unsigned char tp)
{
	fl->fl_type = tp;
}

static inline struct file *compat_file_lock_file(const struct file_lock *fl)
{
	return fl->fl_file;
}

static inline void compat_file_lock_set_file(struct file_lock *fl, struct file *file)
{
	fl->fl_file = file;
}

static inline unsigned int *compat_file_lock_flags(struct file_lock *fl)
{
	return &fl->fl_flags;
}

#endif /* COMPAT_DETECT_STRUCT_FILE_LOCK_CORE_6_9 */

static inline struct inode *compat_file_lock_inode(const struct file_lock *fl)
{
	struct file *file = compat_file_lock_file(fl);
	return (file ? file_inode(file) : NULL);
}

#endif /* __COMPAT_LINUX_FILELOCK_H__ */
