#ifndef __COMPAT_LINUX_NAMEI_H__
#define __COMPAT_LINUX_NAMEI_H__

#include_next <linux/namei.h>

#ifndef COMPAT_DETECT_LOOKUP_ONE_LEN_UNLOCKED_6_16
extern struct dentry *lookup_one_len_unlocked(const char *name,
					      struct dentry *base,
					      int len);
#endif /* COMPAT_DETECT_LOOKUP_ONE_LEN_UNLOCKED_6_16 */

#ifndef COMPAT_DETECT_LOOKUP_ONE_LEN_6_16
extern struct dentry *lookup_one_len(const char *name,
				     struct dentry *base, int len);
#endif /* COMPAT_DETECT_LOOKUP_ONE_LEN_6_16 */

#ifndef COMPAT_DETECT_LOOKUP_POSITIVE_UNLOCKED_6_16
extern struct dentry *lookup_positive_unlocked(const char *name,
					       struct dentry *base,
					       int len);
#endif /* COMPAT_DETECT_LOOKUP_POSITIVE_UNLOCKED_6_16 */

#endif /* __COMPAT_LINUX_NAMEI_H__ */
