#ifndef __COMPAT_LINUX_PAGEMAP_H__
#define __COMPAT_LINUX_PAGEMAP_H__

#include_next <linux/pagemap.h>

#ifndef MAX_PAGECACHE_ORDER
#ifdef CONFIG_TRANSPARENT_HUGEPAGE
#define MAX_PAGECACHE_ORDER	HPAGE_PMD_ORDER
#else
#define MAX_PAGECACHE_ORDER	8
#endif
#endif /* MAX_PAGECACHE_ORDER */

#ifndef COMPAT_DETECT_FGF_SET_ORDER_6_6
typedef unsigned int __bitwise fgf_t;

#define FGP_WRITEBEGIN		(FGP_LOCK | FGP_WRITE | FGP_CREAT | FGP_STABLE)
#define FGF_GET_ORDER(fgf)	(((__force unsigned)fgf) >> 26) /* top 6 bits */

static inline fgf_t fgf_set_order(size_t size)
{
	unsigned int shift = ilog2(size);

	if (shift <= PAGE_SHIFT)
		return 0;
	return (__force fgf_t)((shift - PAGE_SHIFT) << 26);
}

struct folio *vnfs_filemap_get_folio(struct address_space *mapping,
				pgoff_t index, fgf_t fgp_flags, gfp_t gfp);
#define __filemap_get_folio vnfs_filemap_get_folio

#endif /* COMPAT_DETECT_FGF_SET_ORDER_6_6 */

#ifndef COMPAT_DETECT_MAPPING_MAX_FOLIO_SIZE_6_10
static inline size_t mapping_max_folio_size(struct address_space *mapping)
{
	if (mapping_large_folio_support(mapping))
		return PAGE_SIZE << MAX_PAGECACHE_ORDER;
	return PAGE_SIZE;
}
#endif

#ifndef COMPAT_DETECT_FILEMAP_GRAB_FOLIO_6_3
static inline struct folio *filemap_grab_folio(struct address_space *mapping,
								pgoff_t index)
{
       return __filemap_get_folio(mapping, index,
                       FGP_LOCK | FGP_ACCESSED | FGP_CREAT,
                       mapping_gfp_mask(mapping));
}
#endif

#ifndef COMPAT_DETECT_FOLIO_END_READ_6_7
static inline void folio_end_read(struct folio *folio, bool success)
{
	if (likely(success))
		folio_mark_uptodate(folio);
	folio_unlock(folio);
}
#endif

#ifndef COMPAT_DETECT_FOLIO_FILE_MAPPING_6_15
static inline struct address_space *folio_file_mapping(struct folio *folio)
{
	/*
	 * Since v6.11 (7e8e78a0ba00c88 "nfs: remove dead code for the old swap over NFS implementation")
	 * we can go straight to folio->mapping.
	 */
	return folio->mapping;
}
#endif /* COMPAT_DETECT_FOLIO_FILE_MAPPING_6_15 */

#endif /* __COMPAT_LINUX_PAGEMAP_H__ */
