#ifndef __COMPAT_LINUX_SHRINKER_H__
#define __COMPAT_LINUX_SHRINKER_H__

#include_next <linux/shrinker.h>

#ifdef COMPAT_DETECT_DYNAMIC_SHRINKER_ALLOC
#define COMPAT_DYNAMIC_SHRINKER_TYPE		struct shrinker *
#define COMPAT_SHRINKER_ADDRESS(shrinker)	(shrinker)
#else /* !COMPAT_DETECT_DYNAMIC_SHRINKER_ALLOC */
#define COMPAT_DYNAMIC_SHRINKER_TYPE		struct shrinker
#define COMPAT_SHRINKER_ADDRESS(shrinker)	&(shrinker)
#endif /* COMPAT_DETECT_DYNAMIC_SHRINKER_ALLOC */

static inline void compat_shrinker_free(COMPAT_DYNAMIC_SHRINKER_TYPE *shrinker)
{
#ifdef COMPAT_DETECT_DYNAMIC_SHRINKER_ALLOC
	shrinker_free(*shrinker);
	*shrinker = NULL;
#else /* !COMPAT_DETECT_DYNAMIC_SHRINKER_ALLOC */
	unregister_shrinker(shrinker);
#endif /* COMPAT_DETECT_DYNAMIC_SHRINKER_ALLOC */
}

#endif
