#ifndef __COMPAT_LINUX_UIO_H__
#define __COMPAT_LINUX_UIO_H__

#include_next <linux/uio.h>

#ifndef COMPAT_DETECT_COPY_FOLIO_FROM_ITER_ATOMIC_6_6
static inline size_t copy_folio_from_iter_atomic(struct folio *folio,
				size_t offset, size_t bytes, struct iov_iter *i)
{
	return copy_page_from_iter_atomic(&folio->page, offset, bytes, i);
}
#endif

#ifndef COMPAT_DETECT_IOV_ITER_GET_PAGES_ALLOC2_6_0
static inline ssize_t iov_iter_get_pages2(struct iov_iter *i, struct page **pages,
				size_t maxsize, unsigned maxpages, size_t *start)
{
	ssize_t res = iov_iter_get_pages(i, pages, maxsize, maxpages, start);

	if (res >= 0)
		iov_iter_advance(i, res);
	return res;
}

static inline ssize_t iov_iter_get_pages_alloc2(struct iov_iter *i, struct page ***pages,
						size_t maxsize, size_t *start)
{
	ssize_t res = iov_iter_get_pages_alloc(i, pages, maxsize, start);

	if (res >= 0)
		iov_iter_advance(i, res);
	return res;
}
#endif

#endif /* __COMPAT_LINUX_UIO_H__ */
